jQuery(document).ready(function($) {
    function urbLoadRandomImage() {
        $.ajax({
            url: urbAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'urb_get_random_unsplash'
            },
            success: function(response) {
                if (response.success) {
                    const targetDiv = $('#urb');
                    const data = response.data;
                    
                    // Vorlade-Animation für das Bild
                    const img = new Image();
                    img.onload = function() {
                        targetDiv.css({
                            'background-image': 'url(' + data.url + ')',
                            'opacity': 0
                        }).animate({opacity: 1}, 500);
                        
                        // Credits hinzufügen
                        const credits = $('<div class="urb-credits">' +
                            'Foto von <a href="' + data.photo_link + '" target="_blank">' + 
                            data.photographer + '</a> auf Unsplash</div>');
                        targetDiv.find('.urb-credits').remove(); // Alte Credits entfernen
                        targetDiv.append(credits);
                    };
                    img.src = data.url;
                } else {
                    console.error('Fehler beim Laden des Bildes:', response.data);
                }
            },
            error: function(xhr, status, error) {
                console.error('Ajax Fehler:', error);
            }
        });
    }

    // Initial laden
    urbLoadRandomImage();

    // Optional: Neuladen alle 24 Stunden
    setInterval(urbLoadRandomImage, 24 * 60 * 60 * 1000);
});