import { registerBlockType } from '@wordpress/blocks';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, SelectControl, TextControl, ToggleControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

registerBlockType('taxonomy-parent/block', {
    title: __('Taxonomy Parent', 'taxonomy-parent'),
    icon: 'admin-site',
    category: 'widgets',
    attributes: {
        taxonomy: { type: 'string', default: 'category' },
        prefixText: { type: 'string', default: __('Übergeordneter Begriff:', 'taxonomy-parent') },
        asLink: { type: 'boolean', default: true }
    },
    edit: ({ attributes, setAttributes }) => {
        const { taxonomy, prefixText, asLink } = attributes;

        // Prüfen, ob Taxonomien verfügbar sind
        const taxonomies = window?.taxonomyParentData?.taxonomies || [];

        return (
            <>
                <InspectorControls>
                    <PanelBody title={__('Einstellungen', 'taxonomy-parent')}>
                        <SelectControl
                            label={__('Wähle eine Taxonomie', 'taxonomy-parent')}
                            value={taxonomy}
                            options={taxonomies.map((tax) => ({
                                label: tax.label,
                                value: tax.value
                            }))}
                            onChange={(value) => setAttributes({ taxonomy: value })}
                        />
                        <TextControl
                            label={__('Präfix-Text', 'taxonomy-parent')}
                            value={prefixText}
                            onChange={(value) => setAttributes({ prefixText: value })}
                        />
                        <ToggleControl
                            label={__('Als Link anzeigen?', 'taxonomy-parent')}
                            checked={asLink}
                            onChange={(value) => setAttributes({ asLink: value })}
                        />
                    </PanelBody>
                </InspectorControls>
                <div {...useBlockProps()}>
                    {__('Der übergeordnete Begriff wird im Frontend angezeigt.', 'taxonomy-parent')}
                </div>
            </>
        );
    },
    save: () => {
        return null; // Server-Rendering
    }
});
