<?php
/**
 * Plugin Name: URB-Block – Unsplash Random Block
 * Description: Ein Gutenberg-Block mit einem zufälligen Unsplash-Bild als Hintergrund, der weitere Blöcke aufnehmen kann.
 * Plugin URI: https://phoenixseo.de/blog/wordpress-plugin-urb-block
 * Version: 1.0.0
 * Author: PHOENIXSEO.de Frank Pfabigan e.K.
 * Author URI: https://phoenixseo.de
 * Text Domain: urb-block
 * License: GPL v2 or later
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Sicherheitsabfrage

// Einstellungsseite für API-Schlüssel und Collection ID
function urbblock_register_settings() {
    register_setting( 'urbblock_settings', 'urbblock_unsplash_api_key' );
    register_setting( 'urbblock_settings', 'urbblock_unsplash_collection_id', [ 'default' => '4759555' ] );
}
add_action( 'admin_init', 'urbblock_register_settings' );

function urbblock_settings_page() {
    ?>
    <div class="wrap">
        <h1>URB-Block Einstellungen</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields( 'urbblock_settings' );
            do_settings_sections( 'urbblock_settings' );
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Unsplash API Key:</th>
                    <td><input type="text" name="urbblock_unsplash_api_key" value="<?php echo esc_attr( get_option('urbblock_unsplash_api_key') ); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Unsplash Collection ID:</th>
                    <td><input type="text" name="urbblock_unsplash_collection_id" value="<?php echo esc_attr( get_option('urbblock_unsplash_collection_id', '4759555') ); ?>" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

function urbblock_add_menu() {
    add_options_page( 'URB-Block Einstellungen', 'URB-Block', 'manage_options', 'urbblock', 'urbblock_settings_page' );
}
add_action( 'admin_menu', 'urbblock_add_menu' );

function urbblock_fetch_unsplash_image() {
    $api_key = get_option('urbblock_unsplash_api_key');
    $collection_id = get_option('urbblock_unsplash_collection_id', '4759555');
    
    if (!$api_key) {
        return null;
    }
    
    $response = wp_remote_get(
        'https://api.unsplash.com/collections/' . $collection_id . '/photos?per_page=30',
        array(
            'headers' => array(
                'Authorization' => 'Client-ID ' . $api_key
            )
        )
    );
    
    if (is_wp_error($response)) {
        return null;
    }
    
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    
    if (empty($data) || !is_array($data)) {
        return null;
    }
    
    $random_image = $data[array_rand($data)]['urls']['regular'] ?? null;
    return $random_image;
}

function urbblock_enqueue_block_assets() {
    wp_register_script(
        'urbblock',
        plugins_url( 'build/index.js', __FILE__ ),
        array( 'wp-blocks', 'wp-element', 'wp-editor' ),
        filemtime( plugin_dir_path( __FILE__ ) . 'build/index.js' )
    );

    wp_localize_script( 'urbblock', 'urbblockSettings', array(
        'apiKey' => get_option('urbblock_unsplash_api_key'),
        'collectionId' => get_option('urbblock_unsplash_collection_id', '4759555')
    ));

    register_block_type( 'urbblock/unsplash-background', array(
        'editor_script' => 'urbblock',
    ) );
}
add_action( 'init', 'urbblock_enqueue_block_assets' );


